## LBK OA 平台

### 介绍
> LBK OA 平台是LBK的OA系统，包含工单管理、绩效管理。 后端基于go-zero开发，前端基于React+antd 开发。


### 一：核心功能
1. 登录
2. 工单系统
3. 文件系统


### 二：创建api服务
1. cd app 
2. 创建democenter 
3. 创建cmd
4. goctl api new demo 创建api
5. cd app/democenter/cmd/api/desc
6. 编辑好demo.api 描述性文件
7. 执行：goctl api go -api *.api -dir ../  -style=goZero
8. 修改etc/demo.yaml 配置

### 三：创建rpc服务
1. cd app 
2. 创建democenter 
3. 创建cmd
4. goctl rpc new demo 创建rpc
5. cd app/democenter/cmd/rpc/pb/
6. 编辑demo.proto文件
7. 执行：goctl rpc protoc *.proto --go_out=../ --go-grpc_out=../  --zrpc_out=../
8. 执行：sed -i "" 's/,omitempty//g' *.pb.go
9. 修改etc/demo.yaml 配置

> 📢注意：创建api 和 rpc 服务后，先修改etc配置

10. 生成 model 文件

```bash
执行目录参考: /Users/y/Go_Env/src/oa-server/app/issuecenter/model
goctl model mysql ddl -src="./*.sql" -dir="." -c
```



### 四：端口配置
#### 4.1 dev port

#### 4.2 service port
| service name | api service port(1xxx) | rpc service port(2xxx) | other service port(3xxx) |
|--------------|------------------------|------------------------|--------------------------|
| issuecenter  | 1001                   | 2001                   |                          | -                      | -                      | job-3002、schedule-3003   |
| filecenter   | 1002                   | 2002                   |                          | -                      | -                      | job-3002、schedule-3003   |
| usercenter   | 1004                   | 2004                   |                          |

#### 4.3 modd 配置
```shell
# modd 每新增微服务配置以下配置内容

#issuecenter
app/filecenter/cmd/rpc/**/*.go {
    prep: go build -o data/server/filecenter-rpc  -v app/filecenter/cmd/rpc/filecenter.go
    daemon +sigkill: ./data/server/filecenter-rpc -f app/filecenter/cmd/rpc/etc/filecenter.yaml
}
app/filecenter/cmd/api/**/*.go {
    prep: go build -o data/server/filecenter-api  -v app/filecenter/cmd/api/filecenter.go
    daemon +sigkill: ./data/server/filecenter-api -f app/filecenter/cmd/api/etc/filecenter-api.yaml
}
````

#### 4.4 服务配置
```shell
docker-compose.yml 配置,新增port 配置
    ports:
      - "2001:2001" # issue-rpc
      - "1001:1001" # issue-api
      - "2004:2004" # user-rpc
      - "1004:1004"  # user-api
      - "1002:1002" # file-api
````



### 五：部署

```shell
# 编译
docker build -t lbk-oa-server-2024-05-15-17-12 .

# 启动
docker-compose up -d

# 配置 nginx 路由
location ~ ^/issuecenter/v1/(.*) {
proxy_set_header Host $http_host;
proxy_set_header X-Real-IP $remote_addr;
proxy_set_header REMOTE-HOST $remote_addr;
proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;

# 从外部请求到内部服务的映射，省略重复的 url
proxy_pass http://172.19.1.100:1001/issuecenter/v1/$1$is_args$args;
}
```


### 六：规范
1. 文件命名采用小写字母，单词之间拼接
> 例如：usercenter.go
2. 函数命名采用小驼峰命名法
> 例如：func getUserList()
3. 变量命名采用小驼峰命名法
> 例如：var userList

### 七：补充资料
1. [go-zero API语法](https://go-zero.dev/docs/tasks/dsl/api)
2. [proto 语法](https://go-zero.dev/docs/tasks/dsl/proto)
3. [go-zero 官方文档](https://go-zero.dev/docs/tasks)
4. [go-zero-looklook](https://github.com/Mikaelemmmm/go-zero-looklook/blob/main/doc/chinese/01-%E5%BC%80%E5%8F%91%E7%8E%AF%E5%A2%83%E6%90%AD%E5%BB%BA.md)


### 八：中间件
1. 缓存中间件 redis
2. 日志中间件 
3. 链路追踪 
4. 配置中心 
5. 限流中间件 
6. 任务调度中间件 asynq
7. 队列中间件 redis
8. 鉴权中间件 jwt
9. 监控