package file

import (
	"net/http"

	"github.com/zeromicro/go-zero/rest/httpx"

	"oa-server/app/filecenter/api/internal/logic/file"
	"oa-server/app/filecenter/api/internal/svc"
	"oa-server/app/filecenter/api/internal/types"
	"oa-server/common/result"
	"oa-server/response"
)

// download file
func DownloadHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.DownloadRequest
		if err := httpx.Parse(r, &req); err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
			return
		}

		l := file.NewDownloadLogic(r.Context(), svcCtx, w)
		err := l.Download(&req)
		if err != nil {
			response.Error(w, err)
			return
		}
		result.HttpResult(r, w, nil, err)
	}
}
