package file

import (
	"net/http"

	"oa-server/app/filecenter/api/internal/logic/file"
	"oa-server/app/filecenter/api/internal/svc"
	"oa-server/common/result"
)

// UploadHandler upload file
func UploadHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		l := file.NewUploadLogic(r.Context(), svcCtx, r)
		resp, err := l.Upload()
		result.HttpResult(r, w, resp, err)
	}
}
