package file

import (
	"context"
	"io"

	"github.com/zeromicro/go-zero/core/logx"

	"oa-server/app/filecenter/api/internal/svc"
	"oa-server/app/filecenter/api/internal/types"
)

type DownloadLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
	writer io.Writer
}

// download file
func NewDownloadLogic(ctx context.Context, svcCtx *svc.ServiceContext, writer io.Writer) *DownloadLogic {
	return &DownloadLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
		writer: writer,
	}
}

func (l *DownloadLogic) Download(req *types.DownloadRequest) error {
	err := l.svcCtx.FileService.DownloadFile(req.File, req.Target)
	if err != nil {
		return err
	}
	return nil
}
