package file

import (
	"context"
	"net/http"

	"github.com/zeromicro/go-zero/core/logx"

	"oa-server/app/filecenter/api/internal/svc"
	"oa-server/app/filecenter/api/internal/types"
	"oa-server/common/xerr"
)

type UploadLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
	r      *http.Request
}

// NewUploadLogic upload file
func NewUploadLogic(ctx context.Context, svcCtx *svc.ServiceContext, r *http.Request) *UploadLogic {
	return &UploadLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
		r:      r,
	}
}

func (l *UploadLogic) Upload() (resp *types.UploadResponse, err error) {
	file, handle, err := l.r.FormFile("file")
	if file == nil {
		return nil, xerr.NewErrCodeMsg(xerr.FileError, "请先添加要上传文件")
	}
	if err != nil {
		return
	}
	defer file.Close()

	newFileName, err := l.svcCtx.FileService.UploadFile(handle)
	if err != nil {
		return
	}
	resp = &types.UploadResponse{
		FileName: newFileName,
	}
	return
}
