package middleware

import (
	"context"
	"errors"
	"net/http"

	"oa-server/common/ctxdata"
	"oa-server/common/globalkey"
	"oa-server/response"

	lbkUc "git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"github.com/zeromicro/go-zero/core/logx"
)

type AuthMiddleware struct {
	lbkUcClient *lbkUc.Client
}

func NewAuthMiddleware(client *lbkUc.Client) *AuthMiddleware {
	return &AuthMiddleware{lbkUcClient: client}
}

func (m *AuthMiddleware) Handle(next http.HandlerFunc) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		token := r.Header.Get(globalkey.HeaderKeyToken)
		if token == "" {
			response.ErrorWithData(w, errors.New("token缺失"), map[string]any{"reload": true})
			return
		}

		// 校验用户token
		ubi, err := m.lbkUcClient.CheckUserToken(context.Background(), token)
		if err != nil {
			if errors.Is(err, lbkUc.ErrTokenCheckFailed) {
				response.ErrorWithData(w, err, map[string]any{"reload": true})
				return
			}

			logx.Errorw("failed to call usercenter.CheckUserToken", logx.Field("error", err))
			response.Error(w, err)
			return
		}

		ctx := context.WithValue(r.Context(), ctxdata.CtxKeyJwtUserEmail, ubi.Email)
		r = r.WithContext(ctx)

		next(w, r)
	}
}
