package svc

import (
	"oa-server/app/filecenter/api/internal/config"
	"oa-server/common/middleware"
	"oa-server/common/tool"

	lbkUc "git.lbk.world/test/devops/lbk-go-sdk/usercenter"

	"github.com/aliyun/aliyun-oss-go-sdk/oss"
	"github.com/zeromicro/go-zero/rest"
)

type ServiceContext struct {
	Config         config.Config
	OssClient      *oss.Client
	AuthMiddleware rest.Middleware
	FileService    *tool.FileService
}

func NewServiceContext(c config.Config) *ServiceContext {
	lbkUcClient, _ := lbkUc.NewLbkUserClient(c.LbkUsercenter.Env, c.LbkUsercenter.HostInAli)
	fsOssConfig := tool.OssConfig{
		OssEndpoint:   c.AliYunOss.OssEndPoint,
		OssBucketName: c.AliYunOss.BucketName,
		LbkOssApiHost: c.AliYunOss.ApiHost,
		ResourceHost:  c.AliYunOss.ResourceHost,
		ObjectPrefix:  c.AliYunOss.ObjectPrefix,
	}
	oc, err := oss.New(c.AliYunOss.OssEndPoint, c.AliYunOss.AccessKeyId, c.AliYunOss.AccessKeySecret,
		oss.SecurityToken(c.AliYunOss.SecurityToken))
	if err != nil {
		panic(err)
	}
	return &ServiceContext{
		Config:         c,
		OssClient:      oc,
		FileService:    tool.NewFileService(fsOssConfig),
		AuthMiddleware: middleware.NewAuthMiddleware(c.LbkUsercenter.AppName, lbkUcClient).Handle,
	}
}
