package main

import (
	"flag"
	"github.com/zeromicro/go-zero/core/logx"

	"oa-server/app/hrcenter/hr_api/internal/config"
	"oa-server/app/hrcenter/hr_api/internal/handler"
	"oa-server/app/hrcenter/hr_api/internal/svc"

	"github.com/zeromicro/go-zero/core/conf"
	"github.com/zeromicro/go-zero/rest"
)

var configFile = flag.String("f", "etc/hr-api.yaml", "the config file")

func main() {
	flag.Parse()

	var c config.Config
	conf.MustLoad(*configFile, &c)

	server := rest.MustNewServer(c.RestConf)
	defer server.Stop()

	ctx := svc.NewServiceContext(c)
	handler.RegisterHandlers(server, ctx)
	for _, route := range server.Routes() {
		logx.Infof("Method: %s, Path: %s", route.Method, route.Path)
	}
	logx.Infof("Starting server at %s:%d...\n", c.Host, c.Port)
	server.Start()
}
