package hire

import (
	"net/http"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
	"oa-server/app/hrcenter/hr_api/internal/logic/hire"
	"oa-server/app/hrcenter/hr_api/internal/svc"
	"oa-server/app/hrcenter/hr_api/internal/types"
)

func CreateJobPositionHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.CreateJobPositionReq
		if err := httpx.Parse(r, &req); err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
			return
		}

		l := hire.NewCreateJobPositionLogic(r.Context(), svcCtx)
		resp, err := l.CreateJobPosition(&req)
		response.Response(w, resp, err)
	}
}
