package hire

import (
	"net/http"

	"github.com/zeromicro/go-zero/rest/httpx"
	"oa-server/app/hrcenter/hr_api/internal/logic/hire"
	"oa-server/app/hrcenter/hr_api/internal/svc"
	"oa-server/app/hrcenter/hr_api/internal/types"
)

func GetDepartmentListHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.GetDepartmentListReq
		if err := httpx.Parse(r, &req); err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
			return
		}

		l := hire.NewGetDepartmentListLogic(r.Context(), svcCtx)
		resp, err := l.GetDepartmentList(&req)
		if err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
		} else {
			httpx.OkJsonCtx(r.Context(), w, resp)
		}
	}
}
