package hire

import (
	"net/http"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
	"oa-server/app/hrcenter/hr_api/internal/logic/hire"
	"oa-server/app/hrcenter/hr_api/internal/svc"
	"oa-server/app/hrcenter/hr_api/internal/types"
)

func GetJobPositionHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.GetJobPositionReq
		if err := httpx.Parse(r, &req); err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
			return
		}

		l := hire.NewGetJobPositionLogic(r.Context(), svcCtx)
		resp, err := l.GetJobPosition(&req)
		response.Response(w, resp, err)
	}
}
