package hire

import (
	"net/http"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
	"oa-server/app/hrcenter/hr_api/internal/logic/hire"
	"oa-server/app/hrcenter/hr_api/internal/svc"
	"oa-server/app/hrcenter/hr_api/internal/types"
)

func UpdateJobPositionHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.UpdateJobPositionReq
		if err := httpx.Parse(r, &req); err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
			return
		}

		l := hire.NewUpdateJobPositionLogic(r.Context(), svcCtx)
		resp, err := l.UpdateJobPosition(&req)
		response.Response(w, resp, err)
	}
}
