package job

import (
	"net/http"

	"github.com/zeromicro/go-zero/rest/httpx"
	"oa-server/app/hrcenter/hr_api/internal/logic/job"
	"oa-server/app/hrcenter/hr_api/internal/svc"
	"oa-server/app/hrcenter/hr_api/internal/types"
)

func GetJobHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.GetJobReq
		if err := httpx.Parse(r, &req); err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
			return
		}

		l := job.NewGetJobLogic(r.Context(), svcCtx)
		resp, err := l.GetJob(&req)
		job.Response(w, resp, err)
	}
}
