package hire

import (
	"context"
	"errors"
	"oa-server/app/hrcenter/hr_api/internal/svc"
	"oa-server/app/hrcenter/hr_api/internal/types"
	"oa-server/app/hrcenter/hr_rpc/hr"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type CreateJobPositionLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCreateJobPositionLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreateJobPositionLogic {
	return &CreateJobPositionLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CreateJobPositionLogic) CreateJobPosition(req *types.CreateJobPositionReq) (resp *types.EmptyResp, err error) {
	if req.DepartmentID == 0 || req.Email == "" || req.DefaultLanguage == "" || len(req.Positions) == 0 || req.RecruitSwitch == 0 || req.UrgentShortage == 0 {
		logx.Errorw("CreateJobPosition param error")
		return nil, errors.New("参数错误")
	}
	var positions []*hr.PositionInfo
	for _, v := range req.Positions {
		if v.Language == "" || v.PositionName == "" || v.OperatingDuty == "" || v.JobRequirements == "" {
			logx.Errorw("CreateJobPosition param error")
			return nil, errors.New("参数错误")
		}
		positions = append(positions, &hr.PositionInfo{
			Language:        v.Language,
			PositionName:    v.PositionName,
			OperatingDuty:   v.OperatingDuty,
			JobRequirements: v.JobRequirements,
		})
	}

	_, err = l.svcCtx.HireRpc.CreateJobPosition(l.ctx, &hr.CreateJobPositionReq{
		DepartmentId:    req.DepartmentID,
		Email:           req.Email,
		Sort:            req.Sort,
		DefaultLanguage: req.DefaultLanguage,
		RecruitSwitch:   uint32(req.RecruitSwitch),
		UrgentShortage:  uint32(req.UrgentShortage),
		Positions:       positions,
		Operator:        l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string),
	})
	if err != nil {
		return nil, err
	}
	return &types.EmptyResp{}, nil
}
