package hire

import (
	"context"
	"oa-server/app/hrcenter/hr_api/internal/svc"
	"oa-server/app/hrcenter/hr_api/internal/types"
	"oa-server/app/hrcenter/hr_rpc/hr"

	"github.com/zeromicro/go-zero/core/logx"
)

type DeliverRecordLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewDeliverRecordLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DeliverRecordLogic {
	return &DeliverRecordLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *DeliverRecordLogic) DeliverRecord(req *types.DeliverRecordReq) (resp *types.DeliverRecordResp, err error) {
	data, err := l.svcCtx.HireRpc.DeliverRecord(l.ctx, &hr.DeliverRecordReq{
		Id:         req.ID,
		PositionId: req.PositionID,
		Name:       req.Name,
		Exchange:   uint32(req.Exchange),
		Web3:       uint32(req.Web3),
	})
	if err != nil {
		return nil, err
	}

	comments := make([]types.DeliverRecord, len(data.List))
	for i, v := range data.List {
		var resume []types.ResumeInfo
		for _, value := range v.Resume {
			resume = append(resume, types.ResumeInfo{
				Name: value.Name,
				Url:  value.Url,
			})
		}

		comments[i] = types.DeliverRecord{
			RecordID:     v.RecordId,
			Name:         v.Name,
			Email:        v.Email,
			ExchangeName: v.ExchangeName,
			Web3Name:     v.Web3Name,
			Resume:       resume,
			PositionID:   v.PositionId,
			PositionName: v.PositionName,
			CreatedAt:    v.CreatedAt,
		}
	}
	return &types.DeliverRecordResp{
		List: comments,
	}, err
}
