package hire

import (
	"context"
	"oa-server/app/hrcenter/hr_rpc/hr"

	"oa-server/app/hrcenter/hr_api/internal/svc"
	"oa-server/app/hrcenter/hr_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetDepartmentListLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewGetDepartmentListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetDepartmentListLogic {
	return &GetDepartmentListLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetDepartmentListLogic) GetDepartmentList(req *types.GetDepartmentListReq) (resp *types.GetDepartmentListResp, err error) {
	data, err := l.svcCtx.HireRpc.GetDepartmentList(l.ctx, &hr.GetDepartmentListReq{})
	if err != nil {
		return nil, err
	}

	comments := make([]types.Department, len(data.List))
	for i, v := range data.List {
		comments[i] = types.Department{
			ID:   v.Id,
			Name: v.Name,
		}
	}
	return &types.GetDepartmentListResp{
		List: comments,
	}, err
}
