package hire

import (
	"context"
	"oa-server/app/hrcenter/hr_api/internal/svc"
	"oa-server/app/hrcenter/hr_api/internal/types"
	"oa-server/app/hrcenter/hr_rpc/hr"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetJobPositionLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewGetJobPositionLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetJobPositionLogic {
	return &GetJobPositionLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetJobPositionLogic) GetJobPosition(req *types.GetJobPositionReq) (resp *types.GetJobPositionResp, err error) {
	data, err := l.svcCtx.HireRpc.GetJobPosition(l.ctx, &hr.GetJobPositionReq{
		StartTime:    req.StartTime,
		EndTime:      req.EndTime,
		DepartmentId: req.DepartmentID,
		PositionName: req.PositionName,
	})

	comments := make([]types.JobPosition, len(data.List))
	for i, v := range data.List {

		var positions []types.PositionInfo
		for _, position := range v.Positions {
			positions = append(positions, types.PositionInfo{
				Language:        position.Language,
				PositionName:    position.PositionName,
				OperatingDuty:   position.OperatingDuty,
				JobRequirements: position.JobRequirements,
			})
		}

		comments[i] = types.JobPosition{
			PositionID:      v.PositionId,
			Positions:       positions,
			DepartmentID:    v.DepartmentId,
			DepartmentName:  v.DepartmentName,
			Email:           v.Email,
			Sort:            v.Sort,
			DefaultLanguage: v.DefaultLanguage,
			RecruitSwitch:   byte(v.RecruitSwitch),
			UrgentShortage:  byte(v.UrgentShortage),
			DeliverCount:    v.DeliverCount,
			Creator:         v.Creator,
			CreatedAt:       v.CreatedAt,
		}
	}
	return &types.GetJobPositionResp{
		List: comments,
	}, err
}
