package job

import (
	"context"
	"errors"
	"oa-server/app/hrcenter/hr_api/internal/svc"
	"oa-server/app/hrcenter/hr_api/internal/types"
	"oa-server/app/hrcenter/hr_rpc/hr"
	"oa-server/common/ctxdata"
	"strings"
	"unicode/utf8"

	"github.com/zeromicro/go-zero/core/logx"
)

type DeliverResumeLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewDeliverResumeLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DeliverResumeLogic {
	return &DeliverResumeLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *DeliverResumeLogic) DeliverResume(req *types.DeliverResumeReq) (resp *types.DeliverResumeResp, err error) {
	req.Name = strings.Replace(req.Name, " ", "", -1)
	req.Email = strings.Replace(req.Email, " ", "", -1)
	clientType := l.ctx.Value(ctxdata.CtxKeyClientType).(string)

	if req.PositionID == 0 || req.Name == "" || utf8.RuneCountInString(req.Name) > 50 ||
		req.Email == "" || len(req.Email) > 50 || len(req.Resume) == 0 || len(req.Resume) > 3 ||
		utf8.RuneCountInString(req.ExchangeName) > 50 || utf8.RuneCountInString(req.Web3Name) > 50 ||
		req.ValidateData.LotNumber == "" || req.ValidateData.CaptchaOutput == "" || req.ValidateData.PassToken == "" ||
		req.ValidateData.GenTime == "" || clientType == "" {
		logx.Errorw("DeliverResume param error")
		return nil, errors.New("参数错误")
	}

	var resume []*hr.Resume
	for _, value := range req.Resume {
		resume = append(resume, &hr.Resume{
			Name:        value.Name,
			Certificate: value.Certificate,
		})
	}
	validateData := &hr.Validate{
		LotNumber:     req.ValidateData.LotNumber,
		CaptchaOutput: req.ValidateData.CaptchaOutput,
		PassToken:     req.ValidateData.PassToken,
		GenTime:       req.ValidateData.GenTime,
		ClientType:    clientType,
	}
	dataResp, err := l.svcCtx.JobRpc.DeliverResume(l.ctx, &hr.DeliverResumeReq{
		PositionId:   req.PositionID,
		Name:         req.Name,
		Email:        req.Email,
		ExchangeName: req.ExchangeName,
		Web3Name:     req.Web3Name,
		Resume:       resume,
		ValidateData: validateData,
	})
	if err != nil {
		return nil, err
	}
	if dataResp.Message != "" {
		return nil, errors.New(dataResp.Message)
	}
	return &types.DeliverResumeResp{
		Status: dataResp.Status,
	}, err
}
