package job

import (
	"context"
	"oa-server/app/hrcenter/hr_api/internal/svc"
	"oa-server/app/hrcenter/hr_api/internal/types"
	"oa-server/app/hrcenter/hr_rpc/hr"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetJobLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewGetJobLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetJobLogic {
	return &GetJobLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetJobLogic) GetJob(req *types.GetJobReq) (resp *types.GetJobResp, err error) {
	language := l.ctx.Value(ctxdata.CtxKeyAcceptLanguage).(string)
	if language == "" {
		language = English
	}
	data, err := l.svcCtx.JobRpc.GetJob(l.ctx, &hr.GetJobReq{
		Language: language,
	})

	comments := make([]types.JobPositionInfo, len(data.List))
	for i, v := range data.List {
		comments[i] = types.JobPositionInfo{
			PositionID:      v.PositionId,
			PositionName:    v.PositionName,
			OperatingDuty:   v.OperatingDuty,
			JobRequirements: v.JobRequirements,
			DepartmentID:    v.DepartmentId,
			DepartmentName:  v.DepartmentName,
			Email:           v.Email,
			Sort:            v.Sort,
			UrgentShortage:  byte(v.UrgentShortage),
		}
	}
	return &types.GetJobResp{
		List: comments,
	}, err
}
