package job

import (
	"github.com/zeromicro/go-zero/rest/httpx"
	"google.golang.org/grpc/status"
	"net/http"
)

const (
	codeSuccess = 200
	codeError   = -1
)

type Body struct {
	Code int         `json:"code"`
	Msg  string      `json:"message"`
	Data interface{} `json:"data,omitempty"`
}

func Response(w http.ResponseWriter, resp interface{}, err error) {
	if err != nil {
		Error(w, err)
	} else {
		Success(w, resp)
	}
}

func Success(w http.ResponseWriter, data any) {
	httpx.OkJson(w, Body{Code: codeSuccess, Msg: "OK", Data: data})
}

func ErrorWithData(w http.ResponseWriter, err error, data any) {
	if s, ok := status.FromError(err); ok {
		httpx.OkJson(w, Body{Code: int(s.Code()), Msg: s.Message(), Data: data})
		return
	}
	httpx.OkJson(w, Body{Code: codeError, Msg: err.Error(), Data: data})
}

func Error(w http.ResponseWriter, err error) {
	if s, ok := status.FromError(err); ok {
		httpx.OkJson(w, Body{Code: int(s.Code()), Msg: s.Message()})
		return
	}
	httpx.OkJson(w, Body{Code: codeError, Msg: err.Error()})
}
