package svc

import (
	lbkUc "git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"github.com/redis/go-redis/v9"
	"github.com/zeromicro/go-zero/rest"
	"github.com/zeromicro/go-zero/zrpc"
	"oa-server/app/hrcenter/hr_api/internal/config"
	"oa-server/app/hrcenter/hr_api/internal/middleware"
	"oa-server/app/hrcenter/hr_rpc/client/hirerpc"
	"oa-server/app/hrcenter/hr_rpc/client/jobrpc"
)

type ServiceContext struct {
	Config         config.Config
	AuthMiddleware rest.Middleware
	RedisClient    *redis.Client
	HireRpc        hirerpc.HireRpc
	JobRpc         jobrpc.JobRpc
}

func NewServiceContext(c config.Config) *ServiceContext {
	lbkUcClient, _ := lbkUc.NewLbkUserClient(c.LbkUserCenter.Env, c.LbkUserCenter.HostInAli)
	// 创建限流器
	limiter := middleware.NewIPRateLimiter(5, 10)
	svcCtx := &ServiceContext{
		Config: c,
		RedisClient: redis.NewClient(&redis.Options{
			Addr:     c.RedisConf.Host,
			Password: c.RedisConf.Pass,
		}),
		AuthMiddleware: middleware.NewAuthMiddleware(c.LbkUserCenter.AppName, lbkUcClient, limiter).Handle,
		HireRpc:        hirerpc.NewHireRpc(zrpc.MustNewClient(c.HRCenterRpcConf)),
		JobRpc:         jobrpc.NewJobRpc(zrpc.MustNewClient(c.HRCenterRpcConf)),
	}
	return svcCtx
}
