package config

import (
	"github.com/zeromicro/go-zero/core/stores/redis"
	"github.com/zeromicro/go-zero/zrpc"
)

type Config struct {
	zrpc.RpcServerConf
	DB struct {
		DataSource string
	}
	Env            string
	RedisConf      redis.RedisConf
	Lark           Lark
	ImgOSS         ImgOSS
	LbkUsercenter  LbkUsercenter
	UserCenter     UserCenter
	EfficiencyCalc EfficiencyCalc
	Email          Email
	Gt4            Gt4
}

type Gt4 struct {
	Domain      string
	CaptchaData CaptchaData
}
type CaptchaData map[string]struct {
	CaptchaID  string `yaml:"captchaId" json:"captchaId"`
	CaptchaKey string `yaml:"captchaKey" json:"captchaKey"`
}

type ImgOSS struct {
	URL         string
	FileURL     string
	GetFilePath string
}

type Lark struct {
	TestEmail            string
	AppId                string
	AppSecret            string
	GenericTextTmpId     string
	TestDeliverRecordUrl string
	DeliverRecordUrl     string
}

type LbkUsercenter struct {
	AppName   string
	AppToken  string
	Env       string
	HostInAli bool
}

type UserCenter struct {
	URL                string
	DepartmentUserPath string
}

type EfficiencyCalc struct {
	Admin []string
}

type Email struct {
	Port     int
	From     string
	Host     string
	IsSSl    bool
	Secret   string
	Nickname string
}
