package common

import "log"

func AsyncSendLarkMsg(env string, fn func()) {
	safeGo(fn)
}

func safeGo(fn func()) {
	go func() {
		defer func() {
			if err := recover(); err != nil {
				log.Println("recover from panic ", err)
			}
		}()
		fn()
	}()
}
