package hirerpclogic

import (
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

const (
	Chinese = "zh-TW"

	DefaultSort = 999
)

var (
	ErrCreateJobPositionFailed = status.Error(codes.Internal, "添加JobPosition失败")
	ErrUpdateJobPositionFailed = status.Error(codes.Internal, "修改JobPosition失败")
	ErrGetJobPositionFailed    = status.Error(codes.Internal, "查询JobPosition列表失败")

	ErrGetPositionLanguageFailed   = status.Error(codes.Internal, "查询Position多语言信息失败")
	ErrGetDepartmentLanguageFailed = status.Error(codes.Internal, "查询部门多语言信息失败")
	ErrGetDeliverRecordFailed      = status.Error(codes.Internal, "查询岗位投递记录失败")
	ErrGetDeliverCountFailed       = status.Error(codes.Internal, "查询岗位投递数失败")
	ErrGetDepartmentListFailed     = status.Error(codes.Internal, "查询部门列表失败")
)
