package hirerpclogic

import (
	"context"
	"database/sql"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"oa-server/app/hrcenter/hr_rpc/hr"
	"oa-server/app/hrcenter/hr_rpc/internal/svc"
	"oa-server/app/hrcenter/model/hire"
	"time"

	"github.com/zeromicro/go-zero/core/logx"
)

type CreateJobPositionLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewCreateJobPositionLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreateJobPositionLogic {
	return &CreateJobPositionLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *CreateJobPositionLogic) CreateJobPosition(in *hr.CreateJobPositionReq) (*hr.CreateJobPositionResp, error) {
	nowTime := time.Now()

	if in.Sort == 0 {
		in.Sort = DefaultSort
	}

	positionInfo := hire.XPositionInfo{
		DepartmentId:   int64(in.DepartmentId),
		Email:          in.Email,
		Language:       in.DefaultLanguage,
		Sort:           int64(in.Sort),
		RecruitSwitch:  byte(in.RecruitSwitch),
		UrgentShortage: byte(in.UrgentShortage),
		Creator:        in.Operator,
		CreatedAt:      nowTime,
		UpdatedAt:      nowTime,
	}

	err := l.svcCtx.PositionInfoModel.TransCtx(l.ctx, func(ctx context.Context, s sqlx.Session) error {
		insertResult, err := hire.NewXPositionInfoModel(sqlx.NewSqlConnFromSession(s)).Insert(l.ctx, &positionInfo)
		if err != nil {
			logx.Errorw("failed to create positionInfo on CreateJobPosition", logx.Field("error", err))
			return err
		}
		positionInfo.Id, err = insertResult.LastInsertId()
		if err != nil {
			logx.Errorw("failed to get positionInfo create.LastInsertId on CreateJobPosition", logx.Field("error", err))
			return err
		}

		var data []*hire.XPositionLanguageInfo
		for _, v := range in.Positions {
			data = append(data, &hire.XPositionLanguageInfo{
				PositionId:      positionInfo.Id,
				Language:        v.Language,
				PositionName:    v.PositionName,
				OperatingDuty:   sql.NullString{String: v.OperatingDuty, Valid: true},
				JobRequirements: sql.NullString{String: v.JobRequirements, Valid: true},
				CreatedAt:       nowTime,
				UpdatedAt:       nowTime,
			})
		}
		_, err = l.svcCtx.PositionLanguageInfoModel.BatchInsertWithSession(s, data)
		if err != nil {
			logx.Errorw("failed to create positionLanguageInfo on CreateJobPosition", logx.Field("error", err))
			return err
		}

		return nil
	})

	if err != nil {
		return nil, ErrCreateJobPositionFailed
	}

	return &hr.CreateJobPositionResp{Id: uint64(positionInfo.Id)}, nil
}
