package hirerpclogic

import (
	"context"
	"encoding/json"
	"github.com/zeromicro/go-zero/core/logx"
	"oa-server/app/hrcenter/hr_rpc/hr"
	"oa-server/app/hrcenter/hr_rpc/internal/svc"
	"oa-server/app/hrcenter/model/hire"
	"time"
)

type DeliverRecordLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewDeliverRecordLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DeliverRecordLogic {
	return &DeliverRecordLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *DeliverRecordLogic) DeliverRecord(in *hr.DeliverRecordReq) (*hr.DeliverRecordResp, error) {
	req := hire.FindAllDeliverRecordReq{
		ID:         in.Id,
		PositionID: in.PositionId,
		Name:       in.Name,
		Exchange:   in.Exchange,
		Web3:       in.Web3,
	}
	records, err := l.svcCtx.DeliverRecordModel.QueryDeliverRecords(l.ctx, req)
	if err != nil {
		return nil, ErrGetDeliverRecordFailed
	}

	list := make([]*hr.DeliverRecord, len(records))
	for i, v := range records {
		var resumeSlice []*hr.ResumeInfo
		_ = json.Unmarshal([]byte(v.Resume), &resumeSlice)
		list[i] = &hr.DeliverRecord{
			RecordId:     uint64(v.Id),
			Name:         v.Name,
			Email:        v.Email,
			ExchangeName: v.ExchangeName,
			Web3Name:     v.Web3Name,
			Resume:       resumeSlice,
			PositionId:   uint64(v.PositionId),
			PositionName: v.PositionName,
			CreatedAt:    v.CreatedAt.Format(time.DateTime),
		}
	}
	return &hr.DeliverRecordResp{List: list}, nil
}
