package hirerpclogic

import (
	"context"

	"oa-server/app/hrcenter/hr_rpc/hr"
	"oa-server/app/hrcenter/hr_rpc/internal/svc"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetDepartmentListLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewGetDepartmentListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetDepartmentListLogic {
	return &GetDepartmentListLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *GetDepartmentListLogic) GetDepartmentList(in *hr.GetDepartmentListReq) (*hr.GetDepartmentListResp, error) {
	departmentLangs, _, err := l.svcCtx.DepartmentLanguageInfoModel.QueryDepartmentLanguages(l.ctx, []uint64{}, Chinese)
	if err != nil {
		return nil, ErrGetDepartmentListFailed
	}

	list := make([]*hr.DepartmentInfo, len(departmentLangs))
	for i, v := range departmentLangs {
		list[i] = &hr.DepartmentInfo{
			Id:   uint64(v.Id),
			Name: v.DepartmentName,
		}
	}
	return &hr.GetDepartmentListResp{List: list}, nil
}
