package hirerpclogic

import (
	"context"
	"database/sql"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"oa-server/app/hrcenter/model/hire"
	"time"

	"oa-server/app/hrcenter/hr_rpc/hr"
	"oa-server/app/hrcenter/hr_rpc/internal/svc"

	"github.com/zeromicro/go-zero/core/logx"
)

type UpdateJobPositionLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewUpdateJobPositionLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdateJobPositionLogic {
	return &UpdateJobPositionLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *UpdateJobPositionLogic) UpdateJobPosition(in *hr.UpdateJobPositionReq) (*hr.EmptyResponse, error) {
	positionInfo, err := l.svcCtx.PositionInfoModel.FindOne(l.ctx, int64(in.Id))
	if err != nil {
		return nil, ErrUpdateJobPositionFailed
	}

	nowTime := time.Now()
	data := hire.XPositionInfo{
		Id:             int64(in.Id),
		DepartmentId:   int64(in.DepartmentId),
		Email:          in.Email,
		Language:       in.DefaultLanguage,
		Sort:           int64(in.Sort),
		RecruitSwitch:  byte(in.RecruitSwitch),
		UrgentShortage: byte(in.UrgentShortage),
		UpdatedAt:      nowTime,
		Creator:        positionInfo.Creator,
	}

	var positionLanguage []*hire.XPositionLanguageInfo
	for _, v := range in.Positions {
		positionLanguage = append(positionLanguage, &hire.XPositionLanguageInfo{
			PositionId:      int64(in.Id),
			Language:        v.Language,
			PositionName:    v.PositionName,
			OperatingDuty:   sql.NullString{String: v.OperatingDuty, Valid: true},
			JobRequirements: sql.NullString{String: v.JobRequirements, Valid: true},
			CreatedAt:       nowTime,
			UpdatedAt:       nowTime,
		})
	}
	err = l.svcCtx.PositionInfoModel.TransCtx(l.ctx, func(ctx context.Context, s sqlx.Session) error {
		err := hire.NewXPositionInfoModel(sqlx.NewSqlConnFromSession(s)).Update(l.ctx, &data)
		if err != nil {
			logx.Errorw("failed to update positionInfo on UpdateJobPosition", logx.Field("error", err))
			return err
		}

		_, err = l.svcCtx.PositionLanguageInfoModel.BatchUpdateWithSession(s, in.Id, positionLanguage)
		if err != nil {
			logx.Errorw("failed to batch update positionLanguageInfo on UpdateJobPosition", logx.Field("error", err))
			return err
		}
		return nil
	})

	if err != nil {
		return nil, ErrUpdateJobPositionFailed
	}
	return &hr.EmptyResponse{}, nil
}
