package jobrpclogic

import (
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

const (
	NoExperience  byte = 1 // 没有经验
	HasExperience byte = 2 // 有经验

	RecruitClose = 1
	RecruitOpen  = 2

	Chinese        = "zh-TW"
	English string = "en-US"

	TestEnv = "dev"

	SUCCESSSTATUS = "success"
	ERRORSTATUS   = "error"
	FAILSTATUS    = "fail"

	ValidateSuccess = 1 // 校验通过
	ValidateFail    = 2 // 校验失败
	ValidateError   = 3 // 校验异常
)

var (
	ErrDeliverResumeFailed         = status.Error(codes.Internal, "投递简历失败！")
	ErrResumeJsonFailed            = status.Error(codes.Internal, "简历格式有误！")
	ErrHasDeliverResumeFailed      = status.Error(codes.Internal, "查询是否重复投递失败！")
	ErrDeliverCountFailed          = status.Error(codes.Internal, "查询本月投递次数失败！")
	ErrGetJobPositionFailed        = status.Error(codes.Internal, "查询岗位列表失败！")
	ErrGetPositionLanguageFailed   = status.Error(codes.Internal, "查询岗位信息失败！")
	ErrGetDepartmentLanguageFailed = status.Error(codes.Internal, "查询部门信息失败！")
)

const HtmlJobEmailTemplate = `
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>候选人简历投递通知</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; }
        .header { color: #333366; border-bottom: 1px solid #eee; padding-bottom: 10px; }
        .section { margin-bottom: 20px; }
        .section-title { color: #333366; font-weight: bold; margin-bottom: 5px; }
        .job-detail { background-color: #f9f9f9; padding: 15px; border-radius: 5px; }
        .resume-list { list-style-type: none; padding-left: 0; }
        .resume-item { margin-bottom: 5px; }
    </style>
</head>
<body>
    <div class="header">
        <h1>候选人简历投递通知</h1>
    </div>
    
    <div class="section">
        <div class="section-title">候选人信息</div>
        <p><strong>姓名:</strong> %s</p>
        <p><strong>联系邮箱:</strong> %s</p>
        <p><strong>交易所经验:</strong> %s</p>
        <p><strong>Web3经验:</strong> %s</p>
    </div>
    
    <div class="section">
        <div class="section-title">投递职位信息</div>
        <p><strong>职位名称:</strong> %s</p>
    </div>
    
    <div class="section job-detail">
        <div class="section-title">工作职责</div>
        %s
    </div>
    
    <div class="section job-detail">
        <div class="section-title">任职要求</div>
        %s
    </div>
    
    <div class="section">
        <div class="section-title">简历/作品集</div>
        <ul class="resume-list">
            %s
        </ul>
    </div>
</body>
</html>
`
