package svc

import (
	"git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	redisV9 "github.com/redis/go-redis/v9"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"log"
	"oa-server/app/hrcenter/hr_rpc/internal/config"
	"oa-server/app/hrcenter/model/hire"
	"oa-server/app/jobcenter/model"
	"oa-server/common/msgcenter"
)

type ServiceContext struct {
	Config                      config.Config
	RedisClient                 *redisV9.Client
	LarkService                 *msgcenter.LarkService
	LbkUcClient                 *usercenter.LbkUserClient
	UserCache                   *model.UserCenterService
	PositionInfoModel           hire.XPositionInfoModel
	PositionLanguageInfoModel   hire.XPositionLanguageInfoModel
	DepartmentLanguageInfoModel hire.XDepartmentLanguageInfoModel
	DeliverRecordModel          hire.XDeliverRecordModel
}

func NewServiceContext(c config.Config) *ServiceContext {
	// 用户中心客户端
	lbkUcClient, _ := usercenter.NewLbkUserClient(c.LbkUsercenter.Env, c.LbkUsercenter.HostInAli)

	// lark
	larkService, err := msgcenter.NewLarkService(msgcenter.LarkConfig{
		AppID:     c.Lark.AppId,
		AppSecret: c.Lark.AppSecret,
		Env:       c.Env,
	})
	if err != nil {
		log.Fatal("failed to create msgcenter.LarkService ", err)
	}
	sqlConn := sqlx.NewMysql(c.DB.DataSource)
	svcCtx := &ServiceContext{
		Config: c,
		RedisClient: redisV9.NewClient(&redisV9.Options{
			Addr:     c.RedisConf.Host,
			Password: c.RedisConf.Pass,
		}),
		LbkUcClient:                 lbkUcClient,
		LarkService:                 larkService,
		PositionInfoModel:           hire.NewXPositionInfoModel(sqlConn),
		PositionLanguageInfoModel:   hire.NewXPositionLanguageInfoModel(sqlConn),
		DepartmentLanguageInfoModel: hire.NewXDepartmentLanguageInfoModel(sqlConn),
		DeliverRecordModel:          hire.NewXDeliverRecordModel(sqlConn),
	}
	svcCtx.UserCache = model.NewUserCenterService(svcCtx.RedisClient)
	return svcCtx
}
