package hire

import (
	"context"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"time"
)

var _ XDeliverRecordModel = (*customXDeliverRecordModel)(nil)

type (
	// XDeliverRecordModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXDeliverRecordModel.
	XDeliverRecordModel interface {
		xDeliverRecordModel
		withSession(session sqlx.Session) XDeliverRecordModel
		QueryDeliverCounts(ctx context.Context, positionIDs []uint64) (map[uint64]int64, error)
		QueryDeliverRecords(ctx context.Context, req FindAllDeliverRecordReq) ([]*FindAllDeliverRecordResp, error)
		HasDeliveredPosition(email string, positionID uint64) (bool, error)
		DeliveryCount(email string, createAt time.Time) (int, error)
	}

	customXDeliverRecordModel struct {
		*defaultXDeliverRecordModel
	}
)

// NewXDeliverRecordModel returns a model for the database table.
func NewXDeliverRecordModel(conn sqlx.SqlConn) XDeliverRecordModel {
	return &customXDeliverRecordModel{
		defaultXDeliverRecordModel: newXDeliverRecordModel(conn),
	}
}

func (m *customXDeliverRecordModel) withSession(session sqlx.Session) XDeliverRecordModel {
	return NewXDeliverRecordModel(sqlx.NewSqlConnFromSession(session))
}
