// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.5

package hire

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xDeliverRecordFieldNames          = builder.RawFieldNames(&XDeliverRecord{})
	xDeliverRecordRows                = strings.Join(xDeliverRecordFieldNames, ",")
	xDeliverRecordRowsExpectAutoSet   = strings.Join(stringx.Remove(xDeliverRecordFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xDeliverRecordRowsWithPlaceHolder = strings.Join(stringx.Remove(xDeliverRecordFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xDeliverRecordModel interface {
		Insert(ctx context.Context, data *XDeliverRecord) (sql.Result, error)
		FindOne(ctx context.Context, id int64) (*XDeliverRecord, error)
		Update(ctx context.Context, data *XDeliverRecord) error
		Delete(ctx context.Context, id int64) error
	}

	defaultXDeliverRecordModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XDeliverRecord struct {
		Id                 int64        `db:"id"`                  // id
		PositionId         int64        `db:"position_id"`         // 岗位信息id
		Name               string       `db:"name"`                // 姓名
		Email              string       `db:"email"`               // 邮箱
		ExchangeExperience byte         `db:"exchange_experience"` // 是否有交易所经验
		Web3Experience     byte         `db:"web3_experience"`     // 是否有web3经验
		ExchangeName       string       `db:"exchange_name"`       // 交易所名称
		Web3Name           string       `db:"web3_name"`           // web3名称
		Resume             string       `db:"resume"`              // 简历/作品集
		UpdatedAt          time.Time    `db:"updated_at"`
		CreatedAt          time.Time    `db:"created_at"`
	}
)

func newXDeliverRecordModel(conn sqlx.SqlConn) *defaultXDeliverRecordModel {
	return &defaultXDeliverRecordModel{
		conn:  conn,
		table: "`x_deliver_record`",
	}
}

func (m *defaultXDeliverRecordModel) Delete(ctx context.Context, id int64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXDeliverRecordModel) FindOne(ctx context.Context, id int64) (*XDeliverRecord, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xDeliverRecordRows, m.table)
	var resp XDeliverRecord
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXDeliverRecordModel) Insert(ctx context.Context, data *XDeliverRecord) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?)", m.table, xDeliverRecordRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.PositionId, data.Name, data.Email, data.ExchangeExperience, data.Web3Experience, data.ExchangeName, data.Web3Name, data.Resume)
	return ret, err
}

func (m *defaultXDeliverRecordModel) Update(ctx context.Context, data *XDeliverRecord) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xDeliverRecordRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.PositionId, data.Name, data.Email, data.ExchangeExperience, data.Web3Experience, data.ExchangeName, data.Web3Name, data.Resume, data.Id)
	return err
}

func (m *defaultXDeliverRecordModel) tableName() string {
	return m.table
}
