package hire

import (
	"context"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XDepartmentLanguageInfoModel = (*customXDepartmentLanguageInfoModel)(nil)

type (
	// XDepartmentLanguageInfoModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXDepartmentLanguageInfoModel.
	XDepartmentLanguageInfoModel interface {
		xDepartmentLanguageInfoModel
		withSession(session sqlx.Session) XDepartmentLanguageInfoModel
		QueryDepartmentLanguages(ctx context.Context, departmentIDs []uint64, language string) ([]DepartmentLanguageInfo, map[int64]map[string]*DepartmentLanguageInfo, error)
	}

	customXDepartmentLanguageInfoModel struct {
		*defaultXDepartmentLanguageInfoModel
	}
)

// NewXDepartmentLanguageInfoModel returns a model for the database table.
func NewXDepartmentLanguageInfoModel(conn sqlx.SqlConn) XDepartmentLanguageInfoModel {
	return &customXDepartmentLanguageInfoModel{
		defaultXDepartmentLanguageInfoModel: newXDepartmentLanguageInfoModel(conn),
	}
}

func (m *customXDepartmentLanguageInfoModel) withSession(session sqlx.Session) XDepartmentLanguageInfoModel {
	return NewXDepartmentLanguageInfoModel(sqlx.NewSqlConnFromSession(session))
}
