package hire

import (
	"context"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XPositionInfoModel = (*customXPositionInfoModel)(nil)

type (
	// XPositionInfoModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXPositionInfoModel.
	XPositionInfoModel interface {
		xPositionInfoModel
		withSession(session sqlx.Session) XPositionInfoModel
		QueryBasePositions(ctx context.Context, r FindAllJobPositionReq) ([]*XPositionInfo, error)
		UpdateBasePositions(ctx context.Context, session sqlx.Session, req *UpdatePositionReq) error
		TransCtx(ctx context.Context, fn func(ctx context.Context, s sqlx.Session) error) error
	}

	customXPositionInfoModel struct {
		*defaultXPositionInfoModel
	}
)

// NewXPositionInfoModel returns a model for the database table.
func NewXPositionInfoModel(conn sqlx.SqlConn) XPositionInfoModel {
	return &customXPositionInfoModel{
		defaultXPositionInfoModel: newXPositionInfoModel(conn),
	}
}

func (m *customXPositionInfoModel) withSession(session sqlx.Session) XPositionInfoModel {
	return NewXPositionInfoModel(sqlx.NewSqlConnFromSession(session))
}
