// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.5

package hire

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xPositionInfoFieldNames          = builder.RawFieldNames(&XPositionInfo{})
	xPositionInfoRows                = strings.Join(xPositionInfoFieldNames, ",")
	xPositionInfoRowsExpectAutoSet   = strings.Join(stringx.Remove(xPositionInfoFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xPositionInfoRowsWithPlaceHolder = strings.Join(stringx.Remove(xPositionInfoFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xPositionInfoModel interface {
		Insert(ctx context.Context, data *XPositionInfo) (sql.Result, error)
		FindOne(ctx context.Context, id int64) (*XPositionInfo, error)
		Update(ctx context.Context, data *XPositionInfo) error
		Delete(ctx context.Context, id int64) error
	}

	defaultXPositionInfoModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XPositionInfo struct {
		Id             int64        `db:"id"`              // id
		DepartmentId   int64        `db:"department_id"`   // 部门id
		Email          string       `db:"email"`           // 简历接收邮箱
		Language       string       `db:"language"`        // 默认语言
		Sort           int64        `db:"sort"`            // 排序
		RecruitSwitch  byte         `db:"recruit_switch"`  // 招聘开关
		UrgentShortage byte         `db:"urgent_shortage"` // 急缺职位
		Creator        string       `db:"creator"`         // 创建人
		UpdatedAt      time.Time    `db:"updated_at"`
		CreatedAt      time.Time    `db:"created_at"`
	}
)

func newXPositionInfoModel(conn sqlx.SqlConn) *defaultXPositionInfoModel {
	return &defaultXPositionInfoModel{
		conn:  conn,
		table: "`x_position_info`",
	}
}

func (m *defaultXPositionInfoModel) Delete(ctx context.Context, id int64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXPositionInfoModel) FindOne(ctx context.Context, id int64) (*XPositionInfo, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xPositionInfoRows, m.table)
	var resp XPositionInfo
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXPositionInfoModel) Insert(ctx context.Context, data *XPositionInfo) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?)", m.table, xPositionInfoRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.DepartmentId, data.Email, data.Language, data.Sort, data.RecruitSwitch, data.UrgentShortage, data.Creator)
	return ret, err
}

func (m *defaultXPositionInfoModel) Update(ctx context.Context, data *XPositionInfo) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xPositionInfoRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.DepartmentId, data.Email, data.Language, data.Sort, data.RecruitSwitch, data.UrgentShortage, data.Creator, data.Id)
	return err
}

func (m *defaultXPositionInfoModel) tableName() string {
	return m.table
}
