package hire

import (
	"context"
	"database/sql"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"oa-server/app/hrcenter/hr_rpc/hr"
)

var _ XPositionLanguageInfoModel = (*customXPositionLanguageInfoModel)(nil)

type (
	// XPositionLanguageInfoModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXPositionLanguageInfoModel.
	XPositionLanguageInfoModel interface {
		xPositionLanguageInfoModel
		withSession(session sqlx.Session) XPositionLanguageInfoModel
		QueryPositionLanguages(ctx context.Context, positionIDs []uint64, language string) ([]*XPositionLanguageInfo, error)
		BatchInsertWithSession(conn sqlx.Session, data []*XPositionLanguageInfo) (sql.Result, error)
		UpdateLanguageInfos(ctx context.Context, session sqlx.Session, positionID uint64, positionInfo []*hr.PositionInfo) error
		BatchUpdateWithSession(conn sqlx.Session, positionID uint64, data []*XPositionLanguageInfo) (sql.Result, error)
	}

	customXPositionLanguageInfoModel struct {
		*defaultXPositionLanguageInfoModel
	}
)

// NewXPositionLanguageInfoModel returns a model for the database table.
func NewXPositionLanguageInfoModel(conn sqlx.SqlConn) XPositionLanguageInfoModel {
	return &customXPositionLanguageInfoModel{
		defaultXPositionLanguageInfoModel: newXPositionLanguageInfoModel(conn),
	}
}

func (m *customXPositionLanguageInfoModel) withSession(session sqlx.Session) XPositionLanguageInfoModel {
	return NewXPositionLanguageInfoModel(sqlx.NewSqlConnFromSession(session))
}
