// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.5

package hire

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xPositionLanguageInfoFieldNames          = builder.RawFieldNames(&XPositionLanguageInfo{})
	xPositionLanguageInfoRows                = strings.Join(xPositionLanguageInfoFieldNames, ",")
	xPositionLanguageInfoRowsExpectAutoSet   = strings.Join(stringx.Remove(xPositionLanguageInfoFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xPositionLanguageInfoRowsWithPlaceHolder = strings.Join(stringx.Remove(xPositionLanguageInfoFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xPositionLanguageInfoModel interface {
		Insert(ctx context.Context, data *XPositionLanguageInfo) (sql.Result, error)
		FindOne(ctx context.Context, id int64) (*XPositionLanguageInfo, error)
		FindOneByPositionIdLanguage(ctx context.Context, positionId int64, language string) (*XPositionLanguageInfo, error)
		Update(ctx context.Context, data *XPositionLanguageInfo) error
		Delete(ctx context.Context, id int64) error
	}

	defaultXPositionLanguageInfoModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XPositionLanguageInfo struct {
		Id              int64          `db:"id"`               // id
		PositionId      int64          `db:"position_id"`      // 岗位信息id
		Language        string         `db:"language"`         // 语言
		PositionName    string         `db:"position_name"`    // 职位名称
		OperatingDuty   sql.NullString `db:"operating_duty"`   // 工作职责
		JobRequirements sql.NullString `db:"job_requirements"` // 任职要求
		UpdatedAt       time.Time      `db:"updated_at"`
		CreatedAt       time.Time      `db:"created_at"`
	}
)

func newXPositionLanguageInfoModel(conn sqlx.SqlConn) *defaultXPositionLanguageInfoModel {
	return &defaultXPositionLanguageInfoModel{
		conn:  conn,
		table: "`x_position_language_info`",
	}
}

func (m *defaultXPositionLanguageInfoModel) Delete(ctx context.Context, id int64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXPositionLanguageInfoModel) FindOne(ctx context.Context, id int64) (*XPositionLanguageInfo, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xPositionLanguageInfoRows, m.table)
	var resp XPositionLanguageInfo
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXPositionLanguageInfoModel) FindOneByPositionIdLanguage(ctx context.Context, positionId int64, language string) (*XPositionLanguageInfo, error) {
	var resp XPositionLanguageInfo
	query := fmt.Sprintf("select %s from %s where `position_id` = ? and `language` = ? limit 1", xPositionLanguageInfoRows, m.table)
	err := m.conn.QueryRowCtx(ctx, &resp, query, positionId, language)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXPositionLanguageInfoModel) Insert(ctx context.Context, data *XPositionLanguageInfo) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?)", m.table, xPositionLanguageInfoRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.PositionId, data.Language, data.PositionName, data.OperatingDuty, data.JobRequirements)
	return ret, err
}

func (m *defaultXPositionLanguageInfoModel) Update(ctx context.Context, newData *XPositionLanguageInfo) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xPositionLanguageInfoRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, newData.PositionId, newData.Language, newData.PositionName, newData.OperatingDuty, newData.JobRequirements, newData.Id)
	return err
}

func (m *defaultXPositionLanguageInfoModel) tableName() string {
	return m.table
}
