### 1. "add api"

1. route definition

- Url: /issuecenter/v1/issue/add
- Method: POST
- Request: `IssueReq`
- Response: `IssueResp`

2. request definition



```golang
type IssueReq struct {
	Title string `json:"title"` // 标题
	Content string `json:"content"` // 内容
	Severity string `json:"severity"` // 严重程度
	Status int64 `json:"status"` // 状态
	AssignedTo string `json:"assignedTo"` // 分配给
	Tester string `json:"tester"` // 测试
	Reporter string `json:"reporter"` // 测试
	AffectedVersion string `json:"affectedVersion"` // 影响版本
	FixVersion string `json:"fixVersion"` // 修复版本
	Attachments string `json:"attachments"` // 附件
	Type int64 `json:"type"` // 类型
}
```


3. response definition



```golang
type IssueResp struct {
	Id int64 `json:"id"`
}
```

### 2. "close issue"

1. route definition

- Url: /issuecenter/v1/issue/close
- Method: POST
- Request: `CloseIssueReq`
- Response: `CloseIssueResp`

2. request definition



```golang
type CloseIssueReq struct {
	Id int64 `json:"id"`
}
```


3. response definition



```golang
type CloseIssueResp struct {
	Id int64 `json:"id"`
}
```

### 3. "get issue detail by id"

1. route definition

- Url: /issuecenter/v1/issue/detail
- Method: POST
- Request: `GetIssueReq`
- Response: `GetIssueResp`

2. request definition



```golang
type GetIssueReq struct {
	Id int64 `json:"id":"id"`
}
```


3. response definition



```golang
type GetIssueResp struct {
	Id int64 `json:"id"` // 唯一标识符
	Title string `json:"title"` // 标题
	Content string `json:"content"` // 内容
	Severity string `json:"severity"` // 严重程度
	Status int64 `json:"status"` // 状态
	AssignedTo string `json:"assignedTo"` // 分配给
	Tester string `json:"tester"` // 测试
	Developer string `json:"developer"` // 产品负责人
	ProductManager string `json:"productManager"` // 提交人
	Reporter string `json:"reporter"` // 提交人
	AffectedVersion string `json:"affectedVersion"` // 影响版本
	FixVersion string `json:"fixVersion"` // 修复版本
	Attachments string `json:"attachments"` // 附件
	Type int64 `json:"type"` // 类型
	ProcessPos int64 `json:"processPos"` // 当前流程位置
	ProcessStatus int64 `json:"processStatus"` // 当前处理状态
	ProcessApprover string `json:"processApprover"` // 当前处理人
	ProcessApproverCode int64 `json:"processApproverCode"` // 当前处理角色
	ProcessID int64 `json:"processID"` // 当前处理流程 ID
	CreateAt int64 `json:"createAt"`
	UpdateAt int64 `json:"updateAt"`
}
```

### 4. "关注issue"

1. route definition

- Url: /issuecenter/v1/issue/focus
- Method: POST
- Request: `FollowHandleReq`
- Response: `IssueResp`

2. request definition



```golang
type FollowHandleReq struct {
	ID uint32 `json:"id"`
	Handle uint32 `json:"handle"`
}
```


3. response definition



```golang
type IssueResp struct {
	Id int64 `json:"id"`
}
```

### 5. "handle issue"

1. route definition

- Url: /issuecenter/v1/issue/handleprocess
- Method: POST
- Request: `HandleProcessReq`
- Response: `HandleProcessResp`

2. request definition



```golang
type HandleProcessReq struct {
	Id int64 `json:"id"`
	Status int64 `json:"status"` // 要更新的状态
	Assign_type int64 `json:"assignType"` // 分配类型: 1 表示普通处理, 2 表示测试 leader 分配测试, 3 表示测试分配研发和产品
	Remark string `json:"remark"`
	Developer string `json:"developer"` // 开发
	Tester string `json:"tester"` // 测试
	Attachments string `json:"attachments"` // 附件
	Tag string `json:"tag, optional"` // 标签
}
```


3. response definition



```golang
type HandleProcessResp struct {
	Id int64 `json:"id"`
}
```

### 6. "get issue list"

1. route definition

- Url: /issuecenter/v1/issue/list
- Method: POST
- Request: `ListIssueReq`
- Response: `ListIssueResp`

2. request definition



```golang
type ListIssueReq struct {
	Page int32 `json:"page"` // 请求的页码
	PageSize int32 `json:"pageSize"` // 每页显示的条目数
	Title string `json:"title, optional"` // 标题
	Status int64 `json:"status, optional"` // 状态
	Severity string `json:"severity, optional"` // 严重程度
}
```


3. response definition



```golang
type ListIssueResp struct {
	Issues []IssueInfo `json:"issues"` // 问题列表
	Total int64 `json:"total"` // 符合条件的问题总数
}
```

### 7. "我的已办"

1. route definition

- Url: /issuecenter/v1/issue/myDone
- Method: POST
- Request: `myDoneReq`
- Response: `ListIssueResp`

2. request definition



```golang
type MyDoneReq struct {
	Page uint64 `json:"page"`
	PageSize uint64 `json:"pageSize"`
}
```


3. response definition



```golang
type ListIssueResp struct {
	Issues []IssueInfo `json:"issues"` // 问题列表
	Total int64 `json:"total"` // 符合条件的问题总数
}
```

### 8. "我的关注"

1. route definition

- Url: /issuecenter/v1/issue/myFollow
- Method: POST
- Request: `myDoneReq`
- Response: `ListIssueResp`

2. request definition



```golang
type MyDoneReq struct {
	Page uint64 `json:"page"`
	PageSize uint64 `json:"pageSize"`
}
```


3. response definition



```golang
type ListIssueResp struct {
	Issues []IssueInfo `json:"issues"` // 问题列表
	Total int64 `json:"total"` // 符合条件的问题总数
}
```

### 9. "待我处理"

1. route definition

- Url: /issuecenter/v1/issue/myHandle
- Method: POST
- Request: `ListIssueReq`
- Response: `ListIssueResp`

2. request definition



```golang
type ListIssueReq struct {
	Page int32 `json:"page"` // 请求的页码
	PageSize int32 `json:"pageSize"` // 每页显示的条目数
	Title string `json:"title, optional"` // 标题
	Status int64 `json:"status, optional"` // 状态
	Severity string `json:"severity, optional"` // 严重程度
}
```


3. response definition



```golang
type ListIssueResp struct {
	Issues []IssueInfo `json:"issues"` // 问题列表
	Total int64 `json:"total"` // 符合条件的问题总数
}
```

### 10. "我的提交"

1. route definition

- Url: /issuecenter/v1/issue/mySubmit
- Method: POST
- Request: `ListIssueReq`
- Response: `ListIssueResp`

2. request definition



```golang
type ListIssueReq struct {
	Page int32 `json:"page"` // 请求的页码
	PageSize int32 `json:"pageSize"` // 每页显示的条目数
	Title string `json:"title, optional"` // 标题
	Status int64 `json:"status, optional"` // 状态
	Severity string `json:"severity, optional"` // 严重程度
}
```


3. response definition



```golang
type ListIssueResp struct {
	Issues []IssueInfo `json:"issues"` // 问题列表
	Total int64 `json:"total"` // 符合条件的问题总数
}
```

### 11. "我的工作台数量"

1. route definition

- Url: /issuecenter/v1/issue/myWorkbench
- Method: POST
- Request: `-`
- Response: `MyWorkbenchRep`

2. request definition



3. response definition



```golang
type MyWorkbenchRep struct {
	Data []int64 `json:"data"`
}
```

### 12. "get issue process detail by id"

1. route definition

- Url: /issuecenter/v1/issue/process/info
- Method: POST
- Request: `IssueProcessInfoReq`
- Response: `IssueProcessInfo`

2. request definition



```golang
type IssueProcessInfoReq struct {
	Id int64 `json:"id"`
}
```


3. response definition



```golang
type IssueProcessInfo struct {
	Id int64 `json:"id"`
	IssueId int64 `json:"issueId"`
	Pos int64 `json:"pos"`
	Approver string `json:"approver"`
	ApproverCode int `json:"approverCode"`
	Status int `json:"status"`
	ProcessHandler string `json:"processHandler"`
	Remark string `json:"remark"`
	CreateAt int64 `json:"createAt"`
	UpdateAt int64 `json:"updateAt"`
	Attachments string `json:"attachments"`
	Tag string `json:"tag"`
}
```

### 13. "get issue process list"

1. route definition

- Url: /issuecenter/v1/issue/processes/detail
- Method: POST
- Request: `ListIssueProcessReq`
- Response: `ListIssueProcessResp`

2. request definition



```golang
type ListIssueProcessReq struct {
	Id int64 `json:"id"`
}
```


3. response definition



```golang
type ListIssueProcessResp struct {
	IssueProcess []IssueProcessInfo `json:"issues_process"` // 问题列表
	Total int64 `json:"total"` // 符合条件的问题总数
}
```

### 14. "repair issue"

1. route definition

- Url: /issuecenter/v1/issue/repair
- Method: POST
- Request: `UpdateRepairStatusReq`
- Response: `UpdateRepairStatusResp`

2. request definition



```golang
type UpdateRepairStatusReq struct {
	Id int32 `json:"id"`
	EstimatedTime string `json:"estimatedTime"` // 预计时间
	Note string `json:"note"` // 备注
	Status int32 `json:"status"` // 状态  4 修复中  5 已修复
	Attachments string `json:"attachments"` // 修复附件
	IsRejected int32 `json:"is_rejected"` // 1 允许  2 拒绝
	Tag string `json:"tag"` // 标签
}
```


3. response definition



```golang
type UpdateRepairStatusResp struct {
	Success bool `json:"success"`
}
```

### 15. "soft delete issue"

1. route definition

- Url: /issuecenter/v1/issue/softDelete
- Method: POST
- Request: `SoftDeleteIssueReq`
- Response: `SoftDeleteIssueResp`

2. request definition



```golang
type SoftDeleteIssueReq struct {
	IssueId int64 `json:"issueId"` // 要删除的问题 ID
}
```


3. response definition



```golang
type SoftDeleteIssueResp struct {
	IssueId int64 `json:"issueId"` // 要删除的问题 ID
}
```

### 16. "流转issue"

1. route definition

- Url: /issuecenter/v1/issue/transfer
- Method: POST
- Request: `TransferReq`
- Response: `UpdateRepairStatusResp`

2. request definition



```golang
type TransferReq struct {
	Id int64 `json:"id"`
	EstimatedTime int64 `json:"estimatedTime"` // 预计时间
	Note string `json:"note"` // 备注
	Attachments string `json:"attachments"` // 修复附件
	HandleStatus int64 `json:"is_rejected"` // 1 允许  2 拒绝
	Tag string `json:"tag"` // 标签
	Approver string `json:"approver"` // 流转到下一个节点
	Pos int64 `json:"pos"` // 当前流程位置
}
```


3. response definition



```golang
type UpdateRepairStatusResp struct {
	Success bool `json:"success"`
}
```

### 17. "update an issue by id"

1. route definition

- Url: /issuecenter/v1/issue/update
- Method: POST
- Request: `UpdateIssueReq`
- Response: `UpdateIssueResp`

2. request definition



```golang
type UpdateIssueReq struct {
	Id int64 `json:"id"`
	Title string `json:"title"`
	Content string `json:"content"`
	Severity string `json:"severity"`
	Status int64 `json:"status"`
	AssignedTo string `json:"assignedTo"`
	Tester string `json:"tester"` // 研发
	Developer string `json:"developer"` // 产品负责人
	ProductManager string `json:"productManager"` // 提交人
	Reporter string `json:"reporter"`
	AffectedVersion string `json:"affectedVersion"`
	FixVersion string `json:"fixVersion"`
	Attachments string `json:"attachments"`
	Type int64 `json:"type"`
}
```


3. response definition



```golang
type UpdateIssueResp struct {
	Id int64 `json:"id"`
}
```

