package issue

import (
	"net/http"

	"github.com/zeromicro/go-zero/rest/httpx"

	"oa-server/app/issuecenter/issueapi/internal/logic/issue"
	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/common/result"
)

// add api
func AddIssueHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.IssueReq
		if err := httpx.Parse(r, &req); err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
			return
		}

		l := issue.NewAddIssueLogic(r.Context(), svcCtx)
		resp, err := l.AddIssue(&req)
		result.HttpResult(r, w, resp, err) //// 新增微服务需要新配置
	}
}
