package issue

import (
	"net/http"

	"oa-server/app/issuecenter/issueapi/internal/logic/issue"
	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/response"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func FocusIssueHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.FollowHandleReq
		if err := httpx.Parse(r, &req); err != nil {
			httpx.Error(w, err)
			return
		}

		l := issue.NewFocusIssueLogic(r.Context(), svcCtx)
		resp, err := l.FocusIssue(&req)
		if err != nil {
			response.Error(w, err)
			return
		}
		response.Success(w, resp)

	}
}
