package issue

import (
	"net/http"

	"github.com/zeromicro/go-zero/rest/httpx"

	"oa-server/app/issuecenter/issueapi/internal/logic/issue"
	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/common/result"
)

// get issue detail by id
func GetIssueHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.GetIssueReq
		if err := httpx.Parse(r, &req); err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
			return
		}
		l := issue.NewGetIssueLogic(r.Context(), svcCtx)
		resp, err := l.GetIssue(&req)
		result.HttpResult(r, w, resp, err)
	}
}
