package issue

import (
	"net/http"

	"github.com/zeromicro/go-zero/rest/httpx"

	"oa-server/app/issuecenter/issueapi/internal/logic/issue"
	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/common/result"
)

// get issue process detail by id
func GetIssueProcessInfoHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.IssueProcessInfoReq
		if err := httpx.Parse(r, &req); err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
			return
		}

		l := issue.NewGetIssueProcessInfoLogic(r.Context(), svcCtx)
		resp, err := l.GetIssueProcessInfo(&req)
		result.HttpResult(r, w, resp, err)
	}
}
