package issue

import (
	"net/http"

	"github.com/zeromicro/go-zero/rest/httpx"

	"oa-server/app/issuecenter/issueapi/internal/logic/issue"
	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/common/result"
)

// 获取issue列表
func ListIssuesHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.ListIssueReq
		if err := httpx.Parse(r, &req); err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
			return
		}
		l := issue.NewListIssuesLogic(r.Context(), svcCtx)
		resp, err := l.ListIssues(&req)
		result.HttpResult(r, w, resp, err)
	}
}
