package issue

import (
	"net/http"

	"oa-server/common/result"

	"oa-server/app/issuecenter/issueapi/internal/logic/issue"
	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func MyFollowHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.MyDoneReq
		if err := httpx.Parse(r, &req); err != nil {
			result.ParamErrorResult(r, w, err)
			return
		}

		l := issue.NewMyFollowLogic(r.Context(), svcCtx)
		resp, err := l.MyFollow(&req)
		result.HttpResult(r, w, resp, err)
	}
}
