package issue

import (
	"net/http"

	"oa-server/common/result"

	"oa-server/app/issuecenter/issueapi/internal/logic/issue"
	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func MySubmitHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.ListIssueReq
		if err := httpx.Parse(r, &req); err != nil {
			result.ParamErrorResult(r, w, err)
			return
		}

		l := issue.NewMySubmitLogic(r.Context(), svcCtx)
		resp, err := l.MySubmit(&req)
		result.HttpResult(r, w, resp, err)
	}
}
