package issue

import (
	"net/http"

	"oa-server/common/result"

	"oa-server/app/issuecenter/issueapi/internal/logic/issue"
	"oa-server/app/issuecenter/issueapi/internal/svc"
)

func MyWorkbenchHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		l := issue.NewMyWorkbenchLogic(r.Context(), svcCtx)
		resp, err := l.MyWorkbench()
		result.HttpResult(r, w, resp, err)
	}
}
