package issue

import (
	"net/http"

	"oa-server/common/result"

	"github.com/zeromicro/go-zero/rest/httpx"
	"oa-server/app/issuecenter/issueapi/internal/logic/issue"
	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
)

func TransferIssueHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.TransferReq
		if err := httpx.Parse(r, &req); err != nil {
			result.ParamErrorResult(r, w, err)
			return
		}

		l := issue.NewTransferIssueLogic(r.Context(), svcCtx)
		resp, err := l.TransferIssue(&req)
		result.HttpResult(r, w, resp, err)
	}
}
