// Code generated by goctl. DO NOT EDIT.
// goctl 1.8.1

package handler

import (
	"net/http"

	issue "oa-server/app/issuecenter/issueapi/internal/handler/issue"
	"oa-server/app/issuecenter/issueapi/internal/svc"

	"github.com/zeromicro/go-zero/rest"
)

func RegisterHandlers(server *rest.Server, serverCtx *svc.ServiceContext) {
	server.AddRoutes(
		rest.WithMiddlewares(
			[]rest.Middleware{serverCtx.AuthMiddleware},
			[]rest.Route{
				{
					// add api
					Method:  http.MethodPost,
					Path:    "/issue/add",
					Handler: issue.AddIssueHandler(serverCtx),
				},
				{
					// close issue
					Method:  http.MethodPost,
					Path:    "/issue/close",
					Handler: issue.CloseIssueHandler(serverCtx),
				},
				{
					// get issue detail by id
					Method:  http.MethodPost,
					Path:    "/issue/detail",
					Handler: issue.GetIssueHandler(serverCtx),
				},
				{
					// 关注issue
					Method:  http.MethodPost,
					Path:    "/issue/focus",
					Handler: issue.FocusIssueHandler(serverCtx),
				},
				{
					// handle issue
					Method:  http.MethodPost,
					Path:    "/issue/handleprocess",
					Handler: issue.HandleIssueProcessHandler(serverCtx),
				},
				{
					// get issue list
					Method:  http.MethodPost,
					Path:    "/issue/list",
					Handler: issue.ListIssuesHandler(serverCtx),
				},
				{
					// 我的已办
					Method:  http.MethodPost,
					Path:    "/issue/myDone",
					Handler: issue.MyDoneHandler(serverCtx),
				},
				{
					// 我的关注
					Method:  http.MethodPost,
					Path:    "/issue/myFollow",
					Handler: issue.MyFollowHandler(serverCtx),
				},
				{
					// 待我处理
					Method:  http.MethodPost,
					Path:    "/issue/myHandle",
					Handler: issue.MyHandleHandler(serverCtx),
				},
				{
					// 我的提交
					Method:  http.MethodPost,
					Path:    "/issue/mySubmit",
					Handler: issue.MySubmitHandler(serverCtx),
				},
				{
					// 我的工作台数量
					Method:  http.MethodPost,
					Path:    "/issue/myWorkbench",
					Handler: issue.MyWorkbenchHandler(serverCtx),
				},
				{
					// get issue process detail by id
					Method:  http.MethodPost,
					Path:    "/issue/process/info",
					Handler: issue.GetIssueProcessInfoHandler(serverCtx),
				},
				{
					// get issue process list
					Method:  http.MethodPost,
					Path:    "/issue/processes/detail",
					Handler: issue.ListIssueProcessesHandler(serverCtx),
				},
				{
					// repair issue
					Method:  http.MethodPost,
					Path:    "/issue/repair",
					Handler: issue.UpdateRepairStatusHandler(serverCtx),
				},
				{
					// soft delete issue
					Method:  http.MethodPost,
					Path:    "/issue/softDelete",
					Handler: issue.SoftDeleteIssueHandler(serverCtx),
				},
				{
					// 流转issue
					Method:  http.MethodPost,
					Path:    "/issue/transfer",
					Handler: issue.TransferIssueHandler(serverCtx),
				},
				{
					// update an issue by id
					Method:  http.MethodPost,
					Path:    "/issue/update",
					Handler: issue.UpdateIssueHandler(serverCtx),
				},
			}...,
		),
		rest.WithPrefix("/issuecenter/v1"),
	)
}
