package issue

import (
	"context"
	"oa-server/common/ctxdata"
	"time"

	"github.com/jinzhu/copier"
	"github.com/pkg/errors"
	"github.com/zeromicro/go-zero/core/logx"

	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"
	"oa-server/app/issuecenter/issuerpc/issuerpc"
)

type AddIssueLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// NewAddIssueLogic issue添加
func NewAddIssueLogic(ctx context.Context, svcCtx *svc.ServiceContext) *AddIssueLogic {
	return &AddIssueLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *AddIssueLogic) AddIssue(req *types.IssueReq) (*types.IssueResp, error) {
	userInfo := ctxdata.GetUserFromCtx(l.ctx)
	issueResp, err := l.svcCtx.IssueCenterRpc.AddIssue(l.ctx, &issuerpc.IssueReq{
		Title:           req.Title,
		Content:         req.Content,
		Severity:        req.Severity,
		Status:          req.Status,
		Type:            req.Type,
		AssignedTo:      req.AssignedTo,
		Tester:          req.Tester,
		Reporter:        userInfo.Email,
		AffectedVersion: req.AffectedVersion,
		FixVersion:      req.FixVersion,
		Attachments:     req.Attachments,
		CreateAt:        time.Now().Unix(),
	})
	if err != nil {
		return nil, errors.Wrapf(err, "req: %+v", req)
	}
	var resp types.IssueResp
	_ = copier.Copy(&resp, issueResp)
	return &resp, nil
}
