package issue

import (
	"context"
	"oa-server/app/issuecenter/issuerpc/issuerpc"

	"github.com/jinzhu/copier"
	"github.com/pkg/errors"

	"oa-server/app/issuecenter/issueapi/internal/svc"
	"oa-server/app/issuecenter/issueapi/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type CloseIssueLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// close issue
func NewCloseIssueLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CloseIssueLogic {
	return &CloseIssueLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CloseIssueLogic) CloseIssue(req *types.CloseIssueReq) (*types.CloseIssueResp, error) {
	issueResp, err := l.svcCtx.IssueCenterRpc.CloseIssue(l.ctx, &issuerpc.CloseIssueReq{
		Id: req.Id,
	})

	if err != nil {
		return nil, errors.Wrapf(err, "req: %+v", req)
	}

	var resp types.CloseIssueResp
	_ = copier.Copy(&resp, issueResp)
	return &resp, nil
}
